$(function () {
  "use strict";
  //Slider
  var $owl = $(".owl");
  $owl.each(function () {
    var $carousel1 = $(this);
    $carousel1.owlCarousel({
      items: $carousel1.attr("data-items"),
      itemsDesktop: [1199, $carousel1.attr("data-itemsDesktop")],
      itemsDesktopSmall: [979, $carousel1.attr("data-itemsDesktopSmall")],
      itemsTablet: [797, $carousel1.attr("data-itemsTablet")],
      itemsMobile: [479, $carousel1.attr("data-itemsMobile")],
      navigation: JSON.parse($carousel1.attr("data-buttons")),
      pagination: JSON.parse($carousel1.attr("data-pag")),
      slideSpeed: 1000,
      paginationSpeed: 1000,
      navigationText: false,
    });
  });
  $(window).load(function () {
    $(".preloader p").fadeOut();
    $(".preloader").delay(500).fadeOut("slow");
    $("body").delay(600).css({ overflow: "visible" });
  });
  //Image zoom
  $(".image-zoom").magnificPopup({
    delegate: "div a",
    type: "image",
    gallery: {
      enabled: true,
    },
  });
  //Counterup
  $(".counter").counterUp({
    delay: 10,
    time: 2000,
  });
  //Menu
  $(".navbar-toggle").on("click", function () {
    height_w();
  });
  function height_w() {
    $(".navbar-nav").css("max-height", $(window).height() - 165);
  }
  window.onresize = function () {
    height_w();
  };
  //Slider
  $(".slider-range").slider({
    range: true,

    orientation: "horizontal",
    min: 5000,
    max: 999000,
    step: 5000,
    values: [5000, 999000],
    slide: function (event, ui) {
      $(".slider_amount").val(
        "R" +
        ui.values[0].toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +
        " - R" +
        ui.values[1].toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,")
      );
    },
  });
  $(".slider_amount").val(
    "R" +
    $(".slider-range")
      .slider("values", 0)
      .toString()
      .replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +
    " - R" +
    $(".slider-range")
      .slider("values", 1)
      .toString()
      .replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,")
  );
  //Slider Mileage
  $(".slider-range-mileage").slider({
    range: true,
    min: 1000,
    max: 300000,
    step: 1000,
    values: [1000, 300000],
    slide: function (event, ui) {
      $(".slider_amount_mileage").val(
        " " +
        ui.values[0].toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +
        "km" +
        " -  " +
        ui.values[1].toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +
        "km"
      );
    },
  });
  $(".slider_amount_mileage").val(
    " " +
    $(".slider-range-mileage")
      .slider("values", 0)
      .toString()
      .replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +
    "km" +
    " -  " +
    $(".slider-range-mileage")
      .slider("values", 1)
      .toString()
      .replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +
    "km"
  );
  //Search
  $(".select-wrapper li").on("click", function () {
    $(this).parents(".select-wrapper").find("button").text($(this).text());
  });
  //Slider Year
  $(".slider-range-year").slider({
    range: true,
    orientation: "horizontal",
    min: 2000,
    max: 2025,
    step: 1,
    values: [2000, 2025],
    slide: function (event, ui) {
      $(".slider_amount_year").val(
        " " + ui.values[0].toString() + " -  " + ui.values[1].toString()
      );
    },
  });
  $(".slider_amount_year").val(
    " " +
    $(".slider-range-year").slider("values", 0).toString() +
    " -  " +
    $(".slider-range-year").slider("values", 1).toString()
  );
  //Search
  $(".select-wrapper li").on("click", function () {
    $(this).parents(".select-wrapper").find("button").text($(this).text());
  });
  //Layout setting preview
  var $html =
    '<div id="setting"><i className="fa fa-cogs setting-btn"></i><div className="p-lg-15"><h5>Layout</h5><ul className="model-display"><li className="c-option light-version" data-c="light-version">Light</li><li className="c-option dark-version" data-c="dark-version">Dark</li></ul><h5>Display Mode</h5><ul className="model-display"><li className="mode-option wide" data-mode="wide">Wide</li><li className="mode-option boxed" data-mode="boxed">Boxed</li></ul><h5>Background</h5><ul className="model-display fd"><li className="bg-option s-color-1" data-cl="bg-1"></li><li className="bg-option s-color-2"  data-cl="bg-2"></li><li className="bg-option s-color-3" data-cl="bg-3"></li></ul></div></div>';
  $("body").append($html);
  $(".setting-btn").on("click", function () {
    var $obj = $(this);
    if (!$obj.hasClass("active")) {
      $obj.parent("#setting").css("right", "-7px");
      $obj.addClass("active");
    } else {
      $obj.parent("#setting").css("right", "-220px");
      $obj.removeClass("active");
    }
  });
  $("#setting .light-version").on("click", function () {
    raclass(".c-option", ".light-version");
    $("#vers").attr("href", "css/light-version.css");
  });
  $("#setting .dark-version").on("click", function () {
    raclass(".c-option", ".dark-version");
    $("#vers").attr("href", "css/dark-version.css");
  });
  $("#setting .wide").on("click", function () {
    if (!$(this).hasClass("active")) {
      $("#boxed").remove();
      raclass(".boxed", ".wide");
    }
  });
  $("#setting .boxed").on("click", function () {
    if (!$(this).hasClass("active")) {
      $("#boxed").remove();
      $("head").append(
        '<link id="boxed" rel="stylesheet" type="text/css" href="css/boxed.css" media="screen">'
      );
      raclass(".wide", ".boxed");
    }
  });
  function raclass(item, e) {
    $(item).removeClass("active");
    $(e).addClass("active");
  }
  $(".bg-option").on("click", function () {
    $("body").attr("class", $(this).attr("data-cl"));
  });
  if ($("#vers").attr("href").indexOf("light") > 0) {
    $("#setting").find(".light-version").addClass("active");
  } else {
    $("#setting").find(".dark-version").addClass("active");
  }
  if (
    $("link#boxed").attr("href") &&
    $("link#boxed").attr("href").indexOf("boxed") > 0
  ) {
    $("#setting").find(".boxed").addClass("active");
  } else {
    $("#setting").find(".wide").addClass("active");
  }
});
